/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GZIPDataCompressionUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static class_2487 compress(Consumer<class_2487> uncompressedBuilder) {
        class_2487 result = new class_2487();
        GZIPDataCompressionUtils.compress(result, uncompressedBuilder);
        return result;
    }

    public static void compress(class_2487 compoundTag, Consumer<class_2487> uncompressedBuilder) {
        class_2487 uncompressedData = new class_2487();
        uncompressedBuilder.accept(uncompressedData);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            class_2507.method_10634((class_2487)uncompressedData, (OutputStream)outputStream);
        }
        catch (IOException e) {
            LOGGER.error("Failed to compress data. Uncompressed data will be stored.", (Throwable)e);
            compoundTag.method_10556("compressed", false);
            compoundTag.method_10566("data", (class_2520)uncompressedData);
            return;
        }
        byte[] compressedData = outputStream.toByteArray();
        try {
            outputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("Failed to close compression stream!", (Throwable)e);
        }
        compoundTag.method_10556("compressed", true);
        compoundTag.method_10570("data", compressedData);
    }

    public static void decompress(class_2487 input, Consumer<class_2487> uncompressedConsumer) {
        class_2487 uncompressedData;
        if (!input.method_10545("compressed") || !input.method_10545("data")) {
            LOGGER.error("Received uncompressed data. This is normal during upgrade procedures, however in any other case this is an error!");
            uncompressedConsumer.accept(input);
            return;
        }
        if (!input.method_10577("compressed")) {
            LOGGER.error("Received uncompressed data. This is normal during upgrade procedures, however in any other case this is an error!");
            uncompressedConsumer.accept(input.method_10562("data"));
            return;
        }
        byte[] compressedData = input.method_10547("data");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(compressedData);
        try {
            uncompressedData = class_2507.method_10629((InputStream)byteArrayInputStream);
        }
        catch (IOException e) {
            LOGGER.error("Failed to decompress data. Uncompressed data will be stored.", (Throwable)e);
            return;
        }
        uncompressedConsumer.accept(uncompressedData);
    }
}

